﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_11_4
{
    public class Chapitre11_4 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        SpriteFont font;

        NetworkSession session;
        AvailableNetworkSessionCollection availableSessions;

        PacketReader packetReader;
        PacketWriter packetWriter;

        string lastStringReceived = "";

        public Chapitre11_4()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            Components.Add(new GamerServicesComponent(this));
        }

        protected override void Initialize()
        {
            base.Initialize();

            packetReader = new PacketReader();
            packetWriter = new PacketWriter();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
            font = Content.Load<SpriteFont>("font");
        }

        protected override void Update(GameTime gameTime)
        {
            if ((Keyboard.GetState().IsKeyDown(Keys.Q) || GamePad.GetState(PlayerIndex.One).IsButtonDown(Buttons.Back)) && session != null)
            {
                session.Dispose();
                session = null;
                availableSessions = null;
            }

            if ((Keyboard.GetState().IsKeyDown(Keys.C) || GamePad.GetState(PlayerIndex.One).IsButtonDown(Buttons.A)) && session == null)
                session = NetworkSession.Create(NetworkSessionType.SystemLink, 2, 31);

            if ((Keyboard.GetState().IsKeyDown(Keys.S) || GamePad.GetState(PlayerIndex.One).IsButtonDown(Buttons.B)) && SignedInGamer.SignedInGamers.Count != 0 && session == null)
            {    
                availableSessions = NetworkSession.Find(NetworkSessionType.SystemLink, 2, null);

                if (availableSessions != null && availableSessions.Count > 0)
                    session = NetworkSession.Join(availableSessions[0]);
            }

            if ((Keyboard.GetState().IsKeyDown(Keys.M) || GamePad.GetState(PlayerIndex.One).IsButtonDown(Buttons.Y)) && session != null)
            {
                packetWriter.Write(DateTime.Now.ToString());
                session.LocalGamers[0].SendData(packetWriter, SendDataOptions.Chat);
            }

            if (session != null)
            {
                session.Update();

                LocalNetworkGamer gamer = session.LocalGamers[0];
                if (gamer.IsDataAvailable) 
                { 
                    NetworkGamer sender;
                    gamer.ReceiveData(packetReader, out sender);
                    if (gamer != sender)
                        lastStringReceived = packetReader.ReadString();
                }
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();
     
            if (session != null)
            {
                if (session.IsHost)
                    spriteBatch.DrawString(font, "Serveur (" + SignedInGamer.SignedInGamers[0].Gamertag + ")", new Vector2(100, 100), Color.White);
                else
                    spriteBatch.DrawString(font, "Client (" + SignedInGamer.SignedInGamers[0].Gamertag + ") connecte sur " + session.Host.ToString() , new Vector2(100, 100), Color.White);

                spriteBatch.DrawString(font, session.AllGamers.Count + " joueur(s) connecte(s)", new Vector2(100, 150), Color.White);

                for (int i = 0; i < session.AllGamers.Count; i++)
                {
                    spriteBatch.DrawString(font, session.AllGamers[i].Gamertag, new Vector2(100, 200 + (i * 50)), Color.White);
                }

                spriteBatch.DrawString(font, "Dernier message recu", new Vector2(500, 100), Color.White);
                spriteBatch.DrawString(font, lastStringReceived, new Vector2(500, 150), Color.White);

                session.Update();
            }

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
